//=============================================================================
// DelayTrigger
//
// Allows you to delay an event or mission state. Good for time-limit missions
// and some other cool things
//
// One good use of this is to call a WhiteTrigger, and delay an action like
// teleporting by 0.4 seconds (default WhiteTrigger value) so that the screen
// is fully white when you're teleported
//=============================================================================
Class DelayTrigger extends MPConvo_Trigger;

var(MPC_DelayTrigger) float delaySeconds;
var DeusExPlayer affectPlayer;

function Touch( actor Other )
{
	if(bCanTouch)
	{
		if(affectPlayer == None)
		{
			affectPlayer = DeusExPlayer(Other);
			SetTimer(delaySeconds, false);
		}
	}
}

function Trigger(Actor Other, Pawn EventInstigator)
{
	if(affectPlayer == None)
	{
		affectPlayer = DeusExPlayer(EventInstigator);
		SetTimer(delaySeconds, false);
	}
}

function Timer()
{
	if(affectPlayer != None)
	{
		DoBoringStuff(affectPlayer);
		DoCoolStuff(affectPlayer); //should probably delete
		affectPlayer = none;
	}
}

defaultproperties
{
     bCanTouch=false
}